<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayRatesTable extends Migration {

	public function up()
	{
		Schema::create('pay_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('appointment_id')->unsigned();
			$table->date('date_from');
			$table->string('date_to')->nullable();
			$table->decimal('pay_per_hour', 8,2)->nullable();
			$table->decimal('pay_per_month', 8,2)->nullable();
			$table->decimal('pension_match_limit_1', 8,2);
			$table->decimal('pension_multiplier_1', 8,2);
			$table->decimal('pension_match_limit_2', 8,2)->nullable();
			$table->decimal('pension_multiplier_2', 8,2);
			$table->decimal('pension_match_limit_3', 8,2);
			$table->decimal('pension_multiplier_3', 8,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pay_rates');
	}
}