<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductAllowedAttributeValue extends Eloquent {

	protected $table = 'products_allowed_attributes_values';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product_attribute_value()
	{
		return $this->belongsTo('App\Models\Product\ProductAttributeValue', 'product_attribute_value_id');
	}

	public function product_abstraction()
	{
		return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
	}

}