<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Timesheet extends Eloquent {

	protected $table = 'timesheets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function project()
	{
		return $this->belongsTo('App\Models\Company\Project', 'project_id');
	}

	public function process()
	{
		return $this->belongsTo('App\Models\HR\Process', 'process_id');
	}

}