<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesReconciliationsTable extends Migration {

	public function up()
	{
		Schema::create('invoices_reconciliations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('invoice_id')->unsigned();
			$table->integer('settlement_id')->unsigned();
			$table->decimal('invoice_amount_reconciled', 8,2);
			$table->integer('invoice_currency_id')->unsigned();
			$table->decimal('settlement_amount_reconciled', 8,2);
			$table->integer('settlement_currency_Id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices_reconciliations');
	}
}