<?php

namespace App\Models\Person;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BankAccount extends Eloquent {

	protected $table = 'bank_account';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function person()
	{
		return $this->belongsTo('App\Models\Person\Person', 'person_id');
	}

}