<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Line extends Eloquent {

	protected $table = 'lines';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product_abstraction()
	{
		return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
	}

	public function currency()
	{
		return $this->belongsTo('App\Models\Finance\Currency', 'currency_id');
	}

	public function lineable()
	{
		return $this->morphTo();
	}

	public function listing()
	{
		return $this->belongsTo('App\Models\Listing\Listing', 'listing_id');
	}

}