<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductCategory extends Eloquent {

	protected $table = 'products_categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function abstracts()
	{
		return $this->morphMany('App\Models\Product\ProductAbstraction', 'abstractable');
	}

	public function products()
	{
		return $this->hasMany('App\Models\Product\Product', 'product_category_id');
	}

}