<?php

namespace App\Models\Stock;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Stock extends Eloquent {

	protected $table = 'stock';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function location()
	{
		return $this->belongsTo('App\Models\Company\Location', 'location_id');
	}

	public function product_abstraction()
	{
		return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
	}

}