<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromocodesTable extends Migration {

	public function up()
	{
		Schema::create('promocodes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->double('amount')->nullable();
			$table->integer('type')->nullable();
			$table->date('date')->nullable();
			$table->integer('duration')->nullable();
			$table->integer('total_available_number')->nullable();
			$table->integer('total_number_for_customer')->nullable();
			$table->integer('min_bid_amount')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('promocodes');
	}
}