<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDelegacjeTable extends Migration {

	public function up()
	{
		Schema::create('delegacje', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('delegowany_id')->unsigned();
			$table->integer('akceptujacy_id');
			$table->string('cel', 200);
			$table->date('data_od');
			$table->date('data_do');
			$table->enum('status', array('NOWA', 'DO_AKCEPTACJI', 'ZAAKCEPTOWANA', 'ODRZUCONA'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('delegacje');
	}
}