<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstagramMediasTable extends Migration {

	public function up()
	{
		Schema::create('instagram_medias', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->text('text')->nullable();
			$table->string('link', 1000)->nullable();
			$table->string('type', 500)->nullable();
			$table->string('location_name', 500)->nullable();
			$table->integer('timestamp');
			$table->integer('likes')->nullable();
			$table->integer('comments')->nullable();
			$table->string('post_id', 500);
			$table->integer('instagram_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('instagram_medias');
	}
}