<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTweetsTable extends Migration {

	public function up()
	{
		Schema::create('tweets', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->text('content')->nullable();
			$table->integer('timestamp');
			$table->integer('retweets')->nullable();
			$table->integer('favorites')->nullable();
			$table->string('post_id', 500);
			$table->integer('twitter_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tweets');
	}
}