<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstagramsTable extends Migration {

	public function up()
	{
		Schema::create('instagrams', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('username', 1000)->nullable();
			$table->text('bio')->nullable();
			$table->string('full_name', 1000)->nullable();
			$table->string('website', 1000)->nullable();
			$table->integer('followers')->nullable();
			$table->float('engagement_rate', 40,20)->nullable();
			$table->float('average_likes', 40,20)->nullable();
			$table->float('average_comments', 40,20)->nullable();
			$table->integer('influencer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('instagrams');
	}
}