<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('search_terms', function(Blueprint $table) {
			$table->foreign('export_id')->references('id')->on('exports')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('influencer_matches', function(Blueprint $table) {
			$table->foreign('search_terms_id')->references('id')->on('search_terms')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('influencer_matches', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('articles', function(Blueprint $table) {
			$table->foreign('blog_id')->references('id')->on('blogs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('facebooks', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('facebook_statuses', function(Blueprint $table) {
			$table->foreign('facebook_id')->references('id')->on('facebooks')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tweets', function(Blueprint $table) {
			$table->foreign('twitter_id')->references('id')->on('twitters')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('twitters', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('instagrams', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('instagram_medias', function(Blueprint $table) {
			$table->foreign('instagram_id')->references('id')->on('instagrams')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('youtubes', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('youtube_videos', function(Blueprint $table) {
			$table->foreign('youtube_id')->references('id')->on('youtubes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('search_terms', function(Blueprint $table) {
			$table->dropForeign('search_terms_export_id_foreign');
		});
		Schema::table('influencer_matches', function(Blueprint $table) {
			$table->dropForeign('influencer_matches_search_terms_id_foreign');
		});
		Schema::table('influencer_matches', function(Blueprint $table) {
			$table->dropForeign('influencer_matches_influencer_id_foreign');
		});
		Schema::table('articles', function(Blueprint $table) {
			$table->dropForeign('articles_blog_id_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_influencer_id_foreign');
		});
		Schema::table('facebooks', function(Blueprint $table) {
			$table->dropForeign('facebooks_influencer_id_foreign');
		});
		Schema::table('facebook_statuses', function(Blueprint $table) {
			$table->dropForeign('facebook_statuses_facebook_id_foreign');
		});
		Schema::table('tweets', function(Blueprint $table) {
			$table->dropForeign('tweets_twitter_id_foreign');
		});
		Schema::table('twitters', function(Blueprint $table) {
			$table->dropForeign('twitters_influencer_id_foreign');
		});
		Schema::table('instagrams', function(Blueprint $table) {
			$table->dropForeign('instagrams_influencer_id_foreign');
		});
		Schema::table('instagram_medias', function(Blueprint $table) {
			$table->dropForeign('instagram_medias_instagram_id_foreign');
		});
		Schema::table('youtubes', function(Blueprint $table) {
			$table->dropForeign('youtubes_influencer_id_foreign');
		});
		Schema::table('youtube_videos', function(Blueprint $table) {
			$table->dropForeign('youtube_videos_youtube_id_foreign');
		});
	}
}