<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacebooksTable extends Migration {

	public function up()
	{
		Schema::create('facebooks', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('url', 1000);
			$table->integer('fans')->nullable();
			$table->string('name', 1000)->nullable();
			$table->text('bio')->nullable();
			$table->float('engagement_rate', 40,20)->nullable();
			$table->string('category', 1000)->nullable();
			$table->string('subcategories', 1000)->nullable();
			$table->float('average_shares', 40,20)->nullable();
			$table->float('average_likes', 40,20)->nullable();
			$table->float('average_comments', 40,20)->nullable();
			$table->integer('influencer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('facebooks');
	}
}