<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfluencersTable extends Migration {

	public function up()
	{
		Schema::create('influencers', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('name', 1000)->nullable();
			$table->string('first_name', 1000)->nullable();
			$table->string('email')->nullable();
			$table->text('description')->nullable();
			$table->string('country')->nullable();
			$table->string('address', 1000)->nullable();
			$table->integer('created_at');
			$table->integer('updated_at')->nullable();
			$table->string('type', 1000)->nullable();
			$table->integer('blog_id')->nullable();
			$table->integer('facebook_id')->nullable();
			$table->integer('twitter_id')->nullable();
			$table->integer('instagram_id')->nullable();
			$table->integer('youtube_id')->nullable();
			$table->integer('pinterest_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('influencers');
	}
}