<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('academic_year_id')->references('id')->on('academic-years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status-changes', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status-changes', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('texts', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('academic_year_id')->references('id')->on('academic-years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_book_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_order_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_academic_year_id_foreign');
		});
		Schema::table('status-changes', function(Blueprint $table) {
			$table->dropForeign('status-changes_status_id_foreign');
		});
		Schema::table('status-changes', function(Blueprint $table) {
			$table->dropForeign('status-changes_order_id_foreign');
		});
		Schema::table('texts', function(Blueprint $table) {
			$table->dropForeign('texts_book_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_book_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_academic_year_id_foreign');
		});
	}
}