<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function partner()
    {
        return $this->belongsTo('App\User', 'partner_id');
    }

    public function subtype()
    {
        return $this->belongsTo('App\SubTypes', 'subtype_id');
    }

    public function status()
    {
        return $this->belongsTo('App\Status', 'status_id');
    }

    public function bids()
    {
        return $this->hasMany('App\Bid', 'project_id');
    }

    public function progress()
    {
        return $this->hasMany('App\Progress', 'project_id');
    }

    public function payment()
    {
        return $this->hasOne('App\Payment', 'project_id');
    }

    public function review()
    {
        return $this->hasOne('App\Review', 'project_id');
    }

}