<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('partner_id')->unsigned()->nullable();
			$table->boolean('partner_finish')->nullable();
			$table->bigInteger('subtype_id')->unsigned();
			$table->bigIncrements('budget');
			$table->string('title', 255);
			$table->text('description');
			$table->integer('status_id')->default('0');
			$table->bigInteger('views')->unsigned()->default('0');
			$table->integer('duration');
			$table->timestamp('withdraw_at')->nullable();
			$table->timestamp('withdraw_verified_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}