<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Chat extends Eloquent {

	protected $table = 'chats';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function project()
	{
		return $this->belongsTo('App\Project', 'project_id');
	}

	public function partner()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'partner_id');
	}

}