<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgressesTable extends Migration {

	public function up()
	{
		Schema::create('progresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('project_id')->unsigned();
			$table->integer('step');
			$table->string('title', 255);
			$table->text('description')->nullable();
			$table->json('attachment')->nullable();
			$table->timestamp('verified_at')->nullable();
			$table->integer('refused_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('progresses');
	}
}