<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Demarche extends Eloquent {

	protected $table = 'demarches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('titre', 'a_la_une', 'resume', 'description', 'body', 'post_scriptum', 'mot_cle', 'observations', 'etat', 'est_publie', 'url', 'cout', 'delai', 'teleprocedure', 'date_publication', 'date_derniere_modification', 'add_by');

	public function sousThemes()
	{
		return $this->belongsToMany('App\Models\Demarches\SousTheme');
	}

	public function logs()
	{
		return $this->hasMany('App\Models\Demarches\LogDemarche');
	}

	public function ajouterPar()
	{
		return $this->belongsTo('App\Models\User', 'add_by');
	}

	public function tags()
	{
		return $this->belongsToMany('App\Models\Demarches\Tag');
	}

	public function textes()
	{
		return $this->belongsToMany('App\Models\Demarches\Texte');
	}

	public function formulaires()
	{
		return $this->belongsToMany('App\Models\Demarches\Formulaire');
	}

	public function modeleLettres()
	{
		return $this->belongsToMany('App\Models\Demarches\ModeleLettre');
	}

	public function faqs()
	{
		return $this->belongsToMany('App\Models\Demarches\Faq');
	}

	public function actualites()
	{
		return $this->belongsToMany('App\Models\Demarches\Actualite');
	}

	public function serviceAdministratifs()
	{
		return $this->belongsToMany('App\Models\Demarches\ServiceAdministratif');
	}

	public function demarcheLies()
	{
		return $this->belongsToMany('App\Models\Demarches\DemarcheLie', 'demarche_lies', 'demarche_parent_id', 'demarche_child_id');
	}

}