<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InfoGenerale extends Eloquent {

	protected $table = 'info_generales';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('resume', 'contenu');

	public function modifierPar()
	{
		return $this->belongsTo('App\Models\User', 'updated_by');
	}

}