<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ModeleLettre extends Eloquent {

	protected $table = 'modele_lettres';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom', 'description', 'post_scriptum', 'observations', 'date_publication', 'date_derniere_modification', 'etat', 'est_publie', 'add_by');

	public function demarches()
	{
		return $this->belongsToMany('App\Models\Demarches\Demarche');
	}

	public function pieceJointes()
	{
		return $this->morphMany('App\Models\Demarches\PieceJointe', 'modele');
	}

}