<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJoinsTable extends Migration {

	public function up()
	{
		Schema::create('joins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('doctype_id')->unsigned();
			$table->bigInteger('lefttable_id')->unsigned();
			$table->string('leftcol');
			$table->enum('jointype', array('left', 'right', 'inner'));
			$table->bigInteger('righttable_id')->unsigned();
			$table->string('rightcol');
		});
	}

	public function down()
	{
		Schema::drop('joins');
	}
}