<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('parameters', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parameters', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('server_id')->references('id')->on('servers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('joins', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('joins', function(Blueprint $table) {
			$table->foreign('lefttable_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('joins', function(Blueprint $table) {
			$table->foreign('righttable_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('response_params', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('response_params', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('client_doctype', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_doctype', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('path_parameters', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctypes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('parameters', function(Blueprint $table) {
			$table->dropForeign('parameters_doctype_id_foreign');
		});
		Schema::table('parameters', function(Blueprint $table) {
			$table->dropForeign('parameters_table_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_server_id_foreign');
		});
		Schema::table('joins', function(Blueprint $table) {
			$table->dropForeign('joins_doctype_id_foreign');
		});
		Schema::table('joins', function(Blueprint $table) {
			$table->dropForeign('joins_lefttable_id_foreign');
		});
		Schema::table('joins', function(Blueprint $table) {
			$table->dropForeign('joins_righttable_id_foreign');
		});
		Schema::table('response_params', function(Blueprint $table) {
			$table->dropForeign('response_params_doctype_id_foreign');
		});
		Schema::table('response_params', function(Blueprint $table) {
			$table->dropForeign('response_params_table_id_foreign');
		});
		Schema::table('client_doctype', function(Blueprint $table) {
			$table->dropForeign('client_doctype_client_id_foreign');
		});
		Schema::table('client_doctype', function(Blueprint $table) {
			$table->dropForeign('client_doctype_doctype_id_foreign');
		});
		Schema::table('path_parameters', function(Blueprint $table) {
			$table->dropForeign('path_parameters_doctype_id_foreign');
		});
	}
}