<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountTypesTable extends Migration {

	public function up()
	{
		Schema::create('account_types', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_type_id')->unsigned()->nullable();
			$table->smallInteger('is_groupable')->unsigned()->default('0');
			$table->integer('code')->unique();
			$table->string('name');
			$table->smallInteger('direct_posting')->unsigned()->default('0');
			$table->smallInteger('hide_in_p_and_l')->unsigned()->default('0');
			$table->smallInteger('hide_when_has_no_entries')->unsigned()->index()->default('0');
			$table->smallInteger('locked')->unsigned()->default('0');
			$table->integer('income_statement_type_id')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('account_types');
	}
}