<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandModelsTable extends Migration {

	public function up()
	{
		Schema::create('brand_models', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('brand_id')->unsigned();
			$table->string('name');
			$table->string('description')->nullable();
			$table->text('remarks')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('brand_models');
	}
}