<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTypesTable extends Migration {

	public function up()
	{
		Schema::create('invoice_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('description')->nullable();
			$table->integer('fiscal_document_type_id')->unsigned();
			$table->smallInteger('cash_invoice')->unsigned()->index()->default('0');
			$table->integer('notification_id')->nullable();
			$table->integer('contact_type_id')->unsigned()->nullable();
			$table->integer('default_financial_account_id')->nullable();
			$table->integer('default_cash_flow_item_id')->nullable();
			$table->integer('default_credit_memo_type_id')->unsigned()->nullable();
			$table->integer('default_debit_memo_type_id')->unsigned()->nullable();
			$table->integer('default_memo_reason_id')->nullable();
			$table->string('document_note')->nullable();
			$table->string('document_note_title')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoice_types');
	}
}