<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemMaterialsTable extends Migration {

	public function up()
	{
		Schema::create('item_materials', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('item_subtype_id')->unsigned();
			$table->decimal('max_stock')->nullable();
			$table->smallInteger('max_stock_decimal_places')->unsigned()->default('2');
			$table->decimal('min_stock')->nullable();
			$table->smallInteger('min_stock_decimal_places')->unsigned()->default('2');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_materials');
	}
}