<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemSalesTable extends Migration {

	public function up()
	{
		Schema::create('item_sales', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('unit_id')->unsigned();
			$table->integer('revenue_classification_id')->unsigned();
			$table->integer('item_tax_schema_id')->unsigned();
			$table->integer('item_withholding_tax_schema_id')->nullable();
			$table->integer('income_account_id');
			$table->smallInteger('locked')->unsigned()->index()->default('0');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_sales');
	}
}