<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemTypesTable extends Migration {

	public function up()
	{
		Schema::create('item_types', function(Blueprint $table) {
			$table->increments('id');
			$table->char('code', 1)->unique();
			$table->string('name');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_types');
	}
}