<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCulturesTable extends Migration {

	public function up()
	{
		Schema::create('cultures', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 5)->unique();
			$table->string('name');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cultures');
	}
}