<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemoTypesTable extends Migration {

	public function up()
	{
		Schema::create('memo_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('description')->nullable();
			$table->integer('fiscal_document_type_id')->unsigned();
			$table->integer('accounting_nature_id')->unsigned();
			$table->smallInteger('automatically_settled')->unsigned()->index()->default('0');
			$table->integer('notification_id')->nullable();
			$table->integer('contact_type_id')->unsigned()->nullable();
			$table->smallInteger('default_financial_account_id')->nullable();
			$table->smallInteger('default_cash_flow_item_id')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('memo_types');
	}
}