<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRegionsTable extends Migration {

	public function up()
	{
		Schema::create('regions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 5)->unique();
			$table->string('name');
			$table->integer('country_id')->unsigned();
			$table->integer('culture_id')->unsigned()->nullable();
			$table->integer('time_zone_id')->unsigned()->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('regions');
	}
}