<?php

namespace Modules\Tax\Sales;

class InvoiceType extends Eloquent {

	protected $table = 'invoice_types';
	public $timestamps = true;

	public function fiscal_document_type()
	{
		return $this->belongsTo('FiscalDocumentType');
	}

	public function default_credit_memo_type()
	{
		return $this->belongsTo('MemoType', 'default_credit_memo_type_id', 'id');
	}

	public function default_debit_memo_type()
	{
		return $this->belongsTo('MemoType', 'default_debit_memo_type_id', 'id');
	}

	public function contact_type()
	{
		return $this->belongsTo('ContactType');
	}

	public function document_type_series()
	{
		return $this->morphMany('DocumentTypeSerie', 'serieable');
	}

	public function document_type_issuing_services()
	{
		return $this->morphMany('DocumentTypeIssuingService', 'serviceable');
	}

}