<?php

namespace Modules\Tax\Business;

class ItemSale extends Eloquent {

	protected $table = 'item_sales';
	public $timestamps = true;

	public function items()
	{
		return $this->morphToMany('Item', 'itemable', 'itemables', 'itemable_id', 'item_id')->withPivot('itemable_type')->wherePivot('itemable_type', self::class);
	}

	public function item_tax_schema()
	{
		return $this->belongsTo('ItemTaxSchema');
	}

	public function item_withholding_tax_schema()
	{
		return $this->belongsTo('ItemWithholdingTaxSchema');
	}

}