<?php

namespace  Modules\\Tax\\Entities\\Core;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Itemable extends Eloquent {

	protected $table = 'itemables';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function item()
	{
		return $this->belongsTo('Item', 'item_id');
	}

	public function itemable()
	{
		return $this->morphTo();
	}

}