<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitDimensionsTable extends Migration {

	public function up()
	{
		Schema::create('unit_dimensions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('base_unit_id')->unsigned();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('unit_dimensions');
	}
}