<?php

namespace Modules\Tax\Business;

class ItemMaterials extends Eloquent {

	protected $table = 'item_materials';
	public $timestamps = true;

	public function items()
	{
		return $this->morphToMany('Item', 'itemable', 'itemables', 'itemable_id', 'item_id')->withPivot('itemable_type')->wherePivot('itemable_type', self::class);
	}

	public function subtype()
	{
		return $this->belongsTo('ItemSubtype', 'item_subtype_id', 'id');
	}

}