<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehicleTable extends Migration {

	public function up()
	{
		Schema::create('vehicle', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('owner_id')->unsigned();
			$table->integer('vechicle_category_id')->unsigned();
			$table->integer('vechicle_model_id')->unsigned();
			$table->integer('year');
			$table->float('price');
			$table->float('mileage');
			$table->string('color');
			$table->string('fuel_type');
			$table->string('transmission');
			$table->text('body_type');
			$table->string('engine_size');
			$table->string('horsepower');
			$table->string('condition');
			$table->string('is_price');
			$table->string('negotiable');
			$table->string('registration_status');
			$table->float('number_of_owners');
			$table->string('vechicle_features');
			$table->string('safety_rating');
			$table->string('servicehistory');
			$table->string('description');
			$table->string('parment_option');
			$table->string('has_been_in_accidents');
			$table->string('has_loan_or_lien');
		});
	}

	public function down()
	{
		Schema::drop('vehicle');
	}
}