<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamMembersTable extends Migration {

	public function up()
	{
		Schema::create('team_members', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('position', 255)->nullable();
			$table->string('specialization', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('image', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('display_order')->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('team_members');
	}
}