<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuildingsTable extends Migration {

	public function up()
	{
		Schema::create('buildings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('model_type', 191);
			$table->integer('model_id')->unsigned();
			$table->boolean('is_active')->default(1);
			$table->date('year_built');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('buildings');
	}
}