<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191)->nullable();
			$table->string('name_en', 191)->nullable();
			$table->boolean('status')->default(1);
			$table->integer('parent_id')->nullable();
			$table->string('image', 191)->nullable();
			$table->tinyInteger('type')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}