<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->boolean('is_active')->default(1);
			$table->string('map')->nullable();
			$table->bigInteger('model_id')->unsigned();
			$table->string('model_type', 191);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}