<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->string('phone_number', 20);
			$table->string('locale', 5)->default('en');
			$table->string('country_code', 5);
			$table->string('email', 191)->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('address', 191)->nullable();
			$table->string('national_id', 191)->nullable();
			$table->datetime('privacy_policy_accepted_at')->nullable();
			$table->datetime('last_login_at')->nullable();
			$table->boolean('is_active')->default(1);
			$table->enum('gender', array(''mail'', ''female''));
			$table->string('profile_image', 191)->nullable();
			$table->boolean('invited')->default(0);
			$table->string('profile_type', 191)->nullable();
			$table->string('record_classification', 191)->nullable();
			$table->string('creation_source', 191)->nullable();
			$table->datetime('creation_date')->nullable();
			$table->string('comapp_id', 191)->nullable();
			$table->string('maximo_id', 191)->nullable();
			$table->string('crm_id', 191)->nullable();
			$table->datetime('birthdate')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}