<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'amount', 'short_url', 'sent_at', 'stage');

    public function notes()
    {
        return $this->hasMany('Notes');
    }

    public function Owner()
    {
        return $this->hasOne('User');
    }

}