<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('last_login');
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email_address')->nullable();
			$table->timestamps();
			$table->string('phone')->nullable();
			$table->text('permissions')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}