<?php

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	public function posts()
	{
		return $this->hasMany('\Post');
	}

	public function user_meta()
	{
		return $this->hasOne('\User_meta');
	}

	public function client_notification()
	{
		return $this->belongsToMany('\Notification');
	}

	public function client_governate()
	{
		return $this->belongsToMany('\Governorate');
	}

	public function likes_posts()
	{
		return $this->belongsToMany('\Post');
	}

	public function user_blood_type()
	{
		return $this->hasOne('\Blood_type');
	}

	public function user_city()
	{
		return $this->hasOne('\City');
	}

	public function client_donation()
	{
		return $this->hasMany('\Donation');
	}

	public function client_blood_types()
	{
		return $this->belongsToMany('\Blood_type');
	}

}