<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderRefTable extends Migration {

	public function up()
	{
		Schema::create('order_ref', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_id');
			$table->bigInteger('user_id');
			$table->string('type');
			$table->decimal('total');
			$table->decimal('tax');
			$table->decimal('discount');
			$table->bigInteger('payment_id');
		});
	}

	public function down()
	{
		Schema::drop('order_ref');
	}
}